<?php

/**
 * Class SecureSoapClient
 *
 * Notice: mustUnderstand is disabled. Enable this, if connecting to
 * a SOAP server with support for this.
 */
class SecureSoapClient extends SoapClient {

    private $username = null;
    private $password = null;

    /**
     * Builds the required SOAP header for use with the WS-Security UsernameToken Profile.
     *
     * @return SoapHeader
     */
    private function build_WSSE_Header() {

        $timestamp = gmdate('Y-m-d\TH:i:s\Z');
        $nonce     = mt_rand();

        $digest    = base64_encode(pack('H*',
                                        sha1(pack('H*', $nonce) . pack('a*', $timestamp) . pack('a*', $this->password))
                                   )
        );

        $auth = '
<wsse:Security SOAP-ENV:mustUnderstand="0" xmlns:wsse="http://docs.oasis-open.' . 'org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd">
<wsse:UsernameToken>
    <wsse:Username>' . $this->username . '</wsse:Username>
    <wsse:Password Type="http://docs.oasis-open.org/wss/2004/01/oasis-200401-' . 'wss-username-token-profile-1.0#PasswordDigest">' . $digest . '</wsse:Password>
    <wsse:Nonce>' . base64_encode(pack('H*', $nonce)) . '</wsse:Nonce>
    <wsu:Created xmlns:wsu="http://docs.oasis-open.org/wss/2004/01/oasis-' . '200401-wss-wssecurity-utility-1.0.xsd">' . $timestamp . '</wsu:Created>
   </wsse:UsernameToken>
</wsse:Security>
';

        $var    = new SoapVar($auth, XSD_ANYXML);
        $header = new SoapHeader("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security", $var, false);

        return $header;
    }

    /**
     * Set the username and password used for authentification in the WSSE headers.
     *
     * @param string $username
     * @param string $password
     */
    public function setCredentials($username, $password) {
        $this->username = $username;
        $this->password = $password;
    }

    /**
     * Overrides the default function call and injects the required WSSE header in each call, then
     * passes the call on to the original function.
     *
     * @param string $function
     * @param array  $args
     * @param null   $options
     * @param null   $input_headers
     * @param null   $output_headers
     *
     * @return mixed
     */
    public function __soapCall(
        $function,
        $args,
        $options = null,
        $input_headers = null,
        $output_headers = null
    ) {

        return parent::__soapCall($function,
                                  $args,
                                  $options,
                                  $this->build_WSSE_Header()
        );
    }
}