<?php
/**
 * USSOP SoapClient demo
 * - using WSSE UsernameToken Profile with PasswordDigest
 */

// the default php soap client has no support for WS-Security headers, load an extended version
require_once dirname(__file__) . '/SecureSoapClient.class.php';

// SOAP interface configuration
$config = array(
    'wsdl'     => 'https://ssl.optimale-praesentation.de/comm/universal/wsdl',
    // always the latest version, use "?v=x.x" for a fixed version for production! (e.g. "v=1.8")
    'username' => 'ENTER_USERNAME_HERE',    // your username and
    'password' => 'MY_VERY_SECRET_PASSWORD' // your password provided by us

);

// configure php soap client, all of this options are ok for our service,
// but this is the suggested set for php.
$soap_options = array(
    'features'     => SOAP_SINGLE_ELEMENT_ARRAYS, // if not set php will compact the result in cases
    // where there is only one result element (not suggested)
    'soap_version' => SOAP_1_1,                   // select soap version (is already specified by WSDL anyway)
    'cache_wsdl'   => WSDL_CACHE_MEMORY,          // clear WSDL cache on reboot
    'ssl_method'   => SOAP_SSL_METHOD_TLS,        // our interface will force SSL connection
    'trace'        => true                        // optional, set to false (default) in production
);

$ussop = new SecureSoapClient($config['wsdl'], $soap_options);
$ussop->setCredentials($config['username'], $config['password']);

try {

    // create an xml element (you can use DOM extension or a simple string, whatever you prefer
    $xml = new SimpleXMLElement('<param_getState></param_getState>');

    // import SimpleXMLElement to DOM to remove the xml header
    $domxml           = dom_import_simplexml($xml);
    $xml_without_head = $domxml->ownerDocument->saveXML($domxml->ownerDocument->documentElement);

    // use getState() to get a list of all accessible categories, attach our xml payload to the request
    $getStateReturn = $ussop->__soapCall('getState',
                                         array(
                                             new SoapVar($xml_without_head, XSD_ANYXML
                                             )
                                         )
    );

    // do something funny and useless with the result... just for demonstration
    foreach($getStateReturn->object as $object) {
        echo $object->category_no . ' - ' . $object->category_type . '<br />';
        // do something useful here ....
    }
    // insert your code here ;)

} catch(Exception $ex) {

    // debug raw response or do something with the exception
    echo $ussop->__getLastResponse();
}

// no need to log-off from soap service when using WSSE headers, so simply quit.
exit;
