<?php
/**
 * USSOP SoapClient demo to connect to USSOP Interface of optimale-praesentation.de
 * PHP 7.4 example
 *
 * - using WSSE UsernameToken Profile with PasswordDigest
 */

// the default php soap client has no support for WS-Security headers, load an extended version
require_once dirname(__file__) . '/SecureSoapClient.class.php';

// SOAP interface configuration
$config = array(
    'wsdl'     => 'https://www.optimale-praesentation.de/comm/universal/wsdl',
    // always the latest version, use "?v=x.x" for a fixed version for production! (e.g. "v=1.8")
    'username' => 'YOUR_USERNAME',    // your username and
    'password' => 'YOUR_PASSWORD'     // your password provided by us
);

// configure php soap client, all of this options are ok for our service,
// but this is the suggested set for php.
$soap_options = array(
    'features'     => SOAP_SINGLE_ELEMENT_ARRAYS, // if not set php will compact the result in cases
    // where there is only one result element (not suggested)
    'soap_version' => SOAP_1_1,                   // select soap version (is already specified by WSDL anyway)
    'cache_wsdl'   => WSDL_CACHE_MEMORY,          // clear WSDL cache on reboot
    'ssl_method'   => SOAP_SSL_METHOD_TLS,        // our interface will force SSL connection
    'trace'        => true                        // optional, set to false (default) in production
);

$ussop = new SecureSoapClient($config['wsdl'], $soap_options);
$ussop->setCredentials($config['username'], $config['password']);

try {
    // create an xml element (you can use DOM extension or a simple string, whatever you prefer
    $xml = new SimpleXMLElement('<param_getState></param_getState>');

    // import SimpleXMLElement to DOM to remove the xml header
    $domxml           = dom_import_simplexml($xml);
    $xml_without_head = $domxml->ownerDocument->saveXML($domxml->ownerDocument->documentElement);

    // use getState() to get a list of all accessible categories, attach our xml payload to the request
    // see more request due to your needs in our documentation
    $getStateReturn = $ussop->__soapCall('getState',
        array(
            new SoapVar($xml_without_head, XSD_ANYXML
            )
        )
    );

    // read response header
    // hint: implement rate limit checks here (see https://docs.secra.dev/ussop/#rate-limits)
    if(function_exists('http_parse_headers')) { // pecl_http needed, see php docs
        $lastHeaders = http_parse_headers($ussop->__getLastResponseHeaders());
    } else {
        $lastHeaders = $ussop->__getLastResponseHeaders();
    }
    echo "Received headers:\n";
    print_r($lastHeaders);
    echo "\n\n";

    // process response payload
    // just for demonstration echo some category details, change the code to fit your needs
    foreach($getStateReturn->object as $object) {
        echo $object->category_no . ' - ' . $object->category_type . "\n";
        // TODO: do something useful here ....
    }

    // TODO: insert more of your code here ;)

} catch(Exception $ex) {

    // TODO: debug raw response or do something with the exception
    echo $ussop->__getLastResponse();
}

// no need to log-off from soap service when using WSSE headers, so simply quit.
exit;
